Attribute VB_Name = "mdOffsetPlane"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function OffsetPlane(geometry As aGeometric, offsetDistance As Double, workplaneName As String, sketchName As String, bNoSketch As Boolean, color As Long)

'Convenience Function to create a workplane offset from the selected workplane or planar face.

'check if the selected entity belongs to a GeometricClass
If geometry Is Nothing Then
    MsgBox ("Entity not Selected")
Else
    Dim blnGeometry As Boolean
    blnGeometry = geometry.IsA("Geometric")
End If

If (blnGeometry) Then
    
    'Get the ProDESKTOP Application object
    GetApplicationObject
    
    'Get the Active PartDocument
    Dim Part As PartDocument
    Set Part = app.GetActiveDoc
    
    'Get the Design
    Dim Design As aDesign
    Set Design = Part.GetDesign
    
    'Get the geoemtry
    Dim geom As zGeometry
    Set geom = geometry.GetGeometricForm
    
    'Create a zPlane
    Dim OffPlane As zPlane
    Set OffPlane = app.GetClass("OffsetPlane").CreateOffsetPlane(geom, offsetDistance)
    
    'Check if a workplane of the given name already exists
    Dim Found As Boolean
    Found = False
    
        Dim currentWorkplane As aWorkplane
    Set currentWorkplane = Part.LookupWorkplane(workplaneName)

    If Not currentWorkplane Is Nothing Then
        Found = True
    End If
    
    If Found Then
        MsgBox ("A workplane already exists with that name. Choose another name")
        Set OffsetPlane = Nothing
        GoTo 1000
    Else
        'Create the Offset Workplane
        Set OffsetPlane = Design.CreateWorkplane(OffPlane, workplaneName)
    End If
    
    'Set the Local Origin
    Dim identity As zMatrix
    Set identity = app.GetClass("Matrix").CreateScaleMatrix(1)
    Dim box As zBox
    Set box = OffPlane.GetBoundingBox(identity)
    bIsEmpty = box.IsEmpty()
    
    If Not bIsEmpty Then
        OffsetPlane.SetLocalOrigin box.GetCenter
    End If
    
    'Create a sketch with the given sketch name
    If Not bNoSketch Then
    
        Dim offsetSketch As aSketch
        Set offsetSketch = OffsetPlane.CreateSketch(sketchName)
        Part.SetActiveSketch offsetSketch
        
        'Set the color for the sketch
        If color < 0 Or color > 11 Then
            color = 4
        End If
        
        
        Dim colorCls As ColorClass
        Dim newColor As zColor
        Set colorCls = app.GetClass("Color")
        Set newColor = colorCls.CreateColor(1, color * 30, 0.35, 1)
        
        offsetSketch.SetColor newColor
    
    End If

Else

    MsgBox ("Improper Selection of Entity")
    Set OffsetPlane = Nothing

End If

1000:
End Function

